--                                      QUICK EDIT

--****************************************************************************************
            
grenademodel = "models/Weapons/w_grenade.mdl"
grenadepower1 = 5000
grenadepower2 = 400
grenadedamage = "explodedamage 2500"
grenaderadius = "exploderadius 3000"


--****************************************************************************************











--

function onInit()
	_swepsetsound(myindex, "single_shot", "Grenade.Blip")
end

function onPrimaryAttack()

        _PlayerViewModelSequence( Owner, ACT_VM_THROW );
	if (_PlayerInfo(Owner, "alive") == false) then return; end
	local grenade = _EntCreate( "prop_physics" );
	_EntPrecacheModel( grenademodel );
	_EntSetModel(grenade, grenademodel);
	_EntSetPos(grenade, vecAdd(_PlayerGetShootPos(Owner),vector3(0,0,0)))
	_EntSetAng(grenade, _PlayerGetShootAng(Owner));
	local power = grenadepower1;
	local fireforce = vecMul(_PlayerGetShootAng(Owner), vector3(power, power, power));
        _EntSpawn(grenade);
        _PhysApplyForce(grenade, fireforce);
	_SWEPUseAmmo(MyIndex, 0, 1);
	_EntFire(grenade, "addoutput", grenaderadius,0)
	_EntFire(grenade, "addoutput", grenadedamage,0)
        _EntFire(grenade, "break", " ", "3.2");
        _PlaySound ( "weapons/melon/HOLYGRENADE.wav" )

end

function onSecondaryAttack()

        _PlayerViewModelSequence( Owner, ACT_VM_THROW );
	if (_PlayerInfo(Owner, "alive") == false) then return; end
	local grenade = _EntCreate( "prop_physics" );
	_EntPrecacheModel( grenademodel );
	_EntSetModel(grenade, grenademodel);
	_EntSetPos(grenade, vecAdd(_PlayerGetShootPos(Owner),vector3(0,0,-30)))
	_EntSetAng(grenade, _PlayerGetShootAng(Owner));
	local power = grenadepower2;
	local fireforce = vecMul(_PlayerGetShootAng(Owner), vector3(power, power, power));
        _EntSpawn(grenade);
        _PhysApplyForce(grenade, fireforce);
	_SWEPUseAmmo(MyIndex, 0, 1);
	_EntFire(grenade, "addoutput", grenaderadius,0)
	_EntFire(grenade, "addoutput", grenadedamage,0)
        _EntFire(grenade, "break", " ", "3.2");
        _PlaySound ( "weapons/melon/HOLYGRENADE.wav" )


end

function onReload( )
        return false;
end




function getWeaponSlot()
	return 5;	
end

function getWeaponSlotPos()
	return 10;	
end

function getFiresUnderwater()
	return true;
end

function getPrimaryShotDelay()
	return 1;
end

function getViewModel( )
	return "models/Weapons/v_grenade.mdl";
end

function getWorldModel( )
	return "models/Weapons/w_grenade.mdl";
end

function getClassName()
	return "weapon_holy_grenade";
end

function getPrintName()
	return "HOLY-GRENADE";
end

function getAnimPrefix()
	return "grenade";
end

function getPrimaryAmmoType()
	return "none";
end

function getSecondaryAmmoType()
	return "none";
end

function getViewKickRandomSecondary()
        return vector3( 0.0, 0.0, 0.0 );
end

function getViewKickSecondary()
        return vector3( 0.0, 0.0, 0.0);
end

function getMaxClipPrimary()
        return 100;
end

function getDefClipPrimary()
        return 100;
end

function getReloadsSingly() 
        return false; 
end